import java.util.HashMap;
import java.util.Scanner;

public class Main {
    public static class AxisCount { int even = 0; int odd = 0; }
    
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int count = scanner.nextInt();
        scanner.nextLine();
        HashMap<Integer, Integer> hashmap1 = new HashMap<>();
        HashMap<Integer, Integer> hashmap2 = new HashMap<>();
        HashMap<Integer, AxisCount> hashmapX = new HashMap<>();
        HashMap<Integer, AxisCount> hashmapY = new HashMap<>();

        int greetings = 0;
        for (int i = 0; i < count; i++) {
            int x = scanner.nextInt();
            int y = scanner.nextInt();
            scanner.nextLine();
            hashmap1.merge(x-y, 1, Integer::sum);
            hashmap2.merge(x+y, 1, Integer::sum);
            if (hashmapX.get(x) == null) hashmapX.put(x, new AxisCount());
            if (hashmapY.get(y) == null) hashmapY.put(y, new AxisCount());
            AxisCount axisCountX = hashmapX.get(x);
            AxisCount axisCountY = hashmapY.get(y);
            if (y % 2 == 0) axisCountX.even++;
            else axisCountX.odd++;
            if (x % 2 == 0) axisCountX.even++;
            else axisCountY.odd++;
        }

        for (Integer coordCount : hashmap1.values())
            greetings += coordCount * (coordCount - 1);
        for (Integer coordCount : hashmap2.values())
            greetings += coordCount * (coordCount - 1);
        for (AxisCount coordCount : hashmapX.values())
            greetings += (coordCount.even * (coordCount.even - 1) + coordCount.odd * (coordCount.odd - 1)) / 2;
        for (AxisCount coordCount : hashmapY.values())
            greetings += (coordCount.even * (coordCount.even - 1) + coordCount.odd * (coordCount.odd - 1)) / 2;

        System.out.print(greetings);
    }
}